<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Variable to hold unit string -->
    <xsl:variable name="unit">
        <xsl:choose>
            <xsl:when test="//@linearUnits = 'Imperial'"> ve stopách</xsl:when>
            <xsl:otherwise> v metrech</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!-- Right-of-Way Takes Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis uzavřené trasy</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis uzavřené trasy</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor"/>
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou 
                                                <xsl:value-of select="$unit"/>, pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Horizontal Alignment Data -->
                                <xsl:for-each select="HorizontalAlignment">
                                    <table cellpadding="2" cellspacing="2" width="80%">
                                        <tbody>
                                            <tr>
                                                <th align="left" lang="en">Parcela</th>
                                                <td colspan="4">
                                                    <xsl:value-of select="@name"/>&#xa0; <xsl:value-of select="@description"/>
                                                </td>
                                            </tr>
                                            <tr><td colspan="5"><hr/></td></tr>
                                            <tr>
                                                <th class="underline" lang="en" valign="top">Bod</th>
                                                <th class="underline" colspan="2" lang="en" valign="top">Odstup /<br/>Vzdálenost</th>
                                                <th class="underline" lang="en" valign="top">Staničení /<br/>Směrník</th>
                                                <th class="underline" lang="en" valign="top">Trasa</th>
                                            </tr>
                                            <xsl:apply-templates select="HorizontalElements/HorizontalLine | HorizontalElements/HorizontalCircle | HorizontalElements/HorizontalSpiral"/>
                                            <tr>
                                                <td lang="en" valign="bottom"><br/> Plocha =</td>
                                                <td colspan="4" valign="bottom">
                                                    <xsl:choose>
                                                        <xsl:when test="//@linearUnits = 'Imperial'">
                                                            <xsl:value-of select="cif:areaFormat(number(@area))"/> st2
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:value-of select="cif:areaFormat(number(@area))"/> m2
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td lang="en">Plocha =</td>
                                                <td colspan="4">
                                                    <xsl:choose>
                                                        <xsl:when test="//@linearUnits = 'Imperial'">
                                                            <xsl:value-of select="cif:acreFormat(number(@area div 43560))"/> akrů
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:value-of select="cif:acreFormat(number(@area div 10000))"/> hektarů
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td colspan="5"><hr/></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <!-- Alignment Linear Data -->
    <xsl:template match="HorizontalLine">
        <tr>
            <td class="sidepad" align="right"><xsl:value-of select="Start/@name"/></td>
            <xsl:choose>
                <xsl:when test="Start/legalReference/@offset &lt; 0">
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:distanceFormat(number(-1 * Start/legalReference/@offset))"/>
                    </td>
                    <td class="sidepad">L</td>
                </xsl:when>
                <xsl:when test="Start/legalReference/@offset &gt; 0">
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset))"/>
                    </td>
                    <td class="sidepad">P</td>
                </xsl:when>
                <xsl:when test="Start/legalReference/@offset = 0">
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset))"/>
                    </td>
                    <td class="sidepad">&#xa0;</td>
                </xsl:when>
                <xsl:otherwise>
                    <td colspan="2">&#xa0;</td>
                </xsl:otherwise>
            </xsl:choose>
            <td class="sidepad" align="center" nowrap="nowrap">
                <xsl:value-of select="cif:stationFormat(number(Start/legalReference/station/@externalStation), string(Start/legalReference/station/@externalStationName))"/>
            </td>
            <td class="sidepad">
                <xsl:value-of select="Start/legalReference/@referenceAlignment"/>
            </td>
        </tr>
        <tr>
            <td class="sidepad">&#xa0;</td>
            <td class="sidepad" align="right">
                <xsl:value-of select="cif:distanceFormat(number(@length))"/>
            </td>
            <td class="sidepad">&#xa0;</td>
            <td class="sidepad" align="center" nowrap="nowrap">
                <xsl:value-of select="cif:directionFormat(number(@direction))"/>
            </td>
        </tr>
        <tr style="line-height:20%;"><td colspan="5">&#xa0;</td></tr>
        <xsl:if test="position() = last()">
            <tr>
                <td class="sidepad" align="right"><xsl:value-of select="End/@name"/></td>
                <xsl:choose>
                    <xsl:when test="End/legalReference/@offset &lt; 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(-1 * End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">L</td>
                    </xsl:when>
                    <xsl:when test="End/legalReference/@offset &gt; 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">P</td>
                    </xsl:when>
                    <xsl:when test="End/legalReference/@offset = 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">&#xa0;</td>
                    </xsl:when>
                    <xsl:otherwise>
                        <td colspan="2">&#xa0;</td>
                    </xsl:otherwise>
                </xsl:choose>
                <td class="sidepad" align="center" nowrap="nowrap">
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </td>
                <td class="sidepad"><xsl:value-of select="End/legalReference/@referenceAlignment"/></td>
            </tr>
        </xsl:if>
    </xsl:template>
    <!-- Alignment Circular Data -->
    <xsl:template match="HorizontalCircle">
        <tr>
            <td class="sidepad" align="right"><xsl:value-of select="Start/@name"/></td>
            <xsl:choose>
                <xsl:when test="Start/legalReference/@offset &lt; 0">
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:distanceFormat(number(-1 * Start/legalReference/@offset))"/>
                    </td>
                    <td class="sidepad">L</td>
                </xsl:when>
                <xsl:when test="Start/legalReference/@offset &gt; 0">
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset))"/>
                    </td>
                    <td class="sidepad">P</td>
                </xsl:when>
                <xsl:when test="Start/legalReference/@offset = 0">
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset))"/>
                    </td>
                    <td class="sidepad">&#xa0;</td>
                </xsl:when>
                <xsl:otherwise>
                    <td colspan="2">&#xa0;</td>
                </xsl:otherwise>
            </xsl:choose>
            <td class="sidepad" align="center" nowrap="nowrap">
                <xsl:value-of select="cif:stationFormat(number(Start/legalReference/station/@externalStation), string(Start/legalReference/station/@externalStationName))"/>
            </td>
            <td class="sidepad">
                <xsl:value-of select="Start/legalReference/@referenceAlignment"/>
            </td>
        </tr>
        <tr>
            <td class="sidepad">&#xa0;</td>
            <td class="sidepad" align="right">
                <xsl:value-of select="cif:distanceFormat(number(@chord))"/>
            </td>
            <td class="sidepad">&#xa0;</td>
            <td class="sidepad" align="center" nowrap="nowrap">
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
            </td>
        </tr>
        <tr style="line-height:20%;"><td colspan="5">&#xa0;</td></tr>
        <xsl:if test="position() = last()">
            <tr>
                <td class="sidepad" align="right"><xsl:value-of select="End/@name"/></td>
                <xsl:choose>
                    <xsl:when test="End/legalReference/@offset &lt; 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(-1 * End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">L</td>
                    </xsl:when>
                    <xsl:when test="End/legalReference/@offset &gt; 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">P</td>
                    </xsl:when>
                    <xsl:when test="End/legalReference/@offset = 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">&#xa0;</td>
                    </xsl:when>
                    <xsl:otherwise>
                        <td colspan="2">&#xa0;</td>
                    </xsl:otherwise>
                </xsl:choose>
                <td class="sidepad" align="center" nowrap="nowrap">
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </td>
                <td class="sidepad"><xsl:value-of select="End/legalReference/@referenceAlignment"/></td>
            </tr>
        </xsl:if>
    </xsl:template>
    <!-- Alignment Spiral Data -->
    <xsl:template match="HorizontalSpiral">
        <tr>
            <td class="sidepad" align="right"><xsl:value-of select="Start/@name"/></td>
            <xsl:choose>
                <xsl:when test="Start/legalReference/@offset &lt; 0">
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:distanceFormat(number(-1 * Start/legalReference/@offset))"/>
                    </td>
                    <td class="sidepad">L</td>
                </xsl:when>
                <xsl:when test="Start/legalReference/@offset &gt; 0">
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset))"/>
                    </td>
                    <td class="sidepad">P</td>
                </xsl:when>
                <xsl:when test="Start/legalReference/@offset = 0">
                    <td class="sidepad" align="right">
                        <xsl:value-of select="cif:distanceFormat(number(Start/legalReference/@offset))"/>
                    </td>
                    <td class="sidepad">&#xa0;</td>
                </xsl:when>
                <xsl:otherwise>
                    <td colspan="2">&#xa0;</td>
                </xsl:otherwise>
            </xsl:choose>
            <td class="sidepad" align="center" nowrap="nowrap">
                <xsl:value-of select="cif:stationFormat(number(Start/legalReference/station/@externalStation), string(Start/legalReference/station/@externalStationName))"/>
            </td>
            <td class="sidepad">
                <xsl:value-of select="Start/legalReference/@referenceAlignment"/>
            </td>
        </tr>
        <tr>
            <td class="sidepad">&#xa0;</td>
            <td class="sidepad" align="right">
                <xsl:value-of select="cif:distanceFormat(number(@longChord))"/>
            </td>
            <td class="sidepad">&#xa0;</td>
            <td class="sidepad" align="center" nowrap="nowrap">
                <xsl:value-of select="cif:directionFormat(number(@chordDirection))"/>
            </td>
        </tr>
        <tr style="line-height:20%;"><td colspan="5">&#xa0;</td></tr>
        <xsl:if test="position() = last()">
            <tr>
                <td class="sidepad" align="right"><xsl:value-of select="End/@name"/></td>
                <xsl:choose>
                    <xsl:when test="End/legalReference/@offset &lt; 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(-1 * End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">L</td>
                    </xsl:when>
                    <xsl:when test="End/legalReference/@offset &gt; 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">P</td>
                    </xsl:when>
                    <xsl:when test="End/legalReference/@offset = 0">
                        <td class="sidepad" align="right">
                            <xsl:value-of select="cif:distanceFormat(number(End/legalReference/@offset))"/>
                        </td>
                        <td class="sidepad">&#xa0;</td>
                    </xsl:when>
                    <xsl:otherwise>
                        <td colspan="2">&#xa0;</td>
                    </xsl:otherwise>
                </xsl:choose>
                <td class="sidepad" align="center" nowrap="nowrap">
                    <xsl:value-of select="cif:stationFormat(number(End/legalReference/station/@externalStation), string(End/legalReference/station/@externalStationName))"/>
                </td>
                <td class="sidepad"><xsl:value-of select="End/legalReference/@referenceAlignment"/></td>
            </tr>
        </xsl:if>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat nejméně jedno uzavřené směrové řešení v <em>Zahrnout</em> v
                <em>Nástroje &gt; XML Výpisy &gt; Uzavřené prvky</em> nebo <em>Nástroje &gt; XML 
                Výpisy &gt; Geometrie</em>.
            </p>
            <p class="normal1" lang="en">
                Tento výpis vyžaduje rereferenční trasu definovanou v poli<em>Referenční trasy
                &gt; Zahrnout</em> v <em>Nástroje &gt; XML Výpisy &gt; Uzavřené prvky</em>, aby byl kompletní.
            </p>
            <p class="normal1" lang="en">
                Tento výpis vyžaduje pro kompletní výpis pojmenované body směrové geometrie.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
